function difference = GMM_res(x, y, moments, W, N_variables, N_ll)
% This function computes the output to be minimized in the GMM procedure
%
% Input:
%   x = parameters to be estimated 
%   y = calibrated parameters     
%   data_moments = 16x1 data moments
%   W = weightning matrix
% 
% Output:
%   output = M' * W * M

if nargin<4
    W = eye(length(moments));
end


% Moving estimated parameters into bounds
x(1) = exp(x(1))/(1+exp(x(1)));                       % epsilon
lambda(1:2) = (1 - 2 * exp(x(2:3))./(1+exp(x(2:3)))); % rhos eigenvalues
x(2) = lambda(1) + lambda(2);                         % rho_a1
x(3) = - lambda(1) * lambda(2);                       % rho_a2

lambda(1:2) = (1 - 2 * exp(x(4:5))./(1+exp(x(4:5)))); % rhos eigenvalues
x(4) = lambda(1) + lambda(2);                         % rho_po1
x(5) = - lambda(1) * lambda(2);                       % rho_po2

x(6:7) = 10^(-7) + exp(x(6:7));                       % var_po var_a
x(6:7) = min(x(6:7), 5);

parameters = [y,x];

try
    model_moments = Model_Moments(parameters, N_variables, N_ll);
    M = (moments - model_moments)';
    difference = M' * W * M;
    disp(['Current Difference = ' num2str(difference)])
catch e
    difference = nan;
    disp(['Dynare error in parameterization'])
    disp(e.message);
end